import { requireAdmin, adminError } from "@/lib/admin";
import { listRsvps } from "@/lib/store";

export async function GET(req, { params }) {
  if (!requireAdmin(req)) return adminError();
  const rsvps = await listRsvps(params.eventId);
  return new Response(JSON.stringify({ rsvps }), { headers: { "content-type": "application/json" } });
}
